using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace _5.Dva_Niza
{
    internal class Program
    {
        public static long Povrsina(List<(long x, long y)> tacke)
        {
            long povrsina = 0;
            int n = tacke.Count;
            for (int i = 0; i < n; i++)
            {
                int j = (i + 1) % n;
                povrsina += tacke[i].x * tacke[j].y - tacke[j].x * tacke[i].y;
            }
            return Math.Abs(povrsina) / 2;
        }

        public static List<(long x, long y)> KonveksniOmotac(List<(long x, long y)> tacke)
        {
            int n = tacke.Count;
            for (int i = 0; i < n - 1; i++)
            {
                for (int j = 0; j < n - 1 - i; j++)
                {
                    if (tacke[j].x > tacke[j + 1].x || (tacke[j].x == tacke[j + 1].x && tacke[j].y > tacke[j + 1].y))
                    {
                        var temp = tacke[j];
                        tacke[j] = tacke[j + 1];
                        tacke[j + 1] = temp;
                    }
                }
            }

            List<(long x, long y)> donja = new List<(long x, long y)>();
            foreach (var tacka in tacke)
            {
                while (donja.Count >= 2 &&
                       (donja[donja.Count - 1].x - donja[donja.Count - 2].x) * (tacka.y - donja[donja.Count - 1].y) -
                       (donja[donja.Count - 1].y - donja[donja.Count - 2].y) * (tacka.x - donja[donja.Count - 1].x) <= 0)
                {
                    donja.RemoveAt(donja.Count - 1);
                }
                donja.Add(tacka);
            }

            List<(long x, long y)> gornja = new List<(long x, long y)>();
            for (int i = tacke.Count - 1; i >= 0; i--)
            {
                while (gornja.Count >= 2 && (gornja[gornja.Count - 1].x - gornja[gornja.Count - 2].x) * (tacke[i].y - gornja[gornja.Count - 1].y) - (gornja[gornja.Count - 1].y - gornja[gornja.Count - 2].y) * (tacke[i].x - gornja[gornja.Count - 1].x) <= 0)
                {
                    gornja.RemoveAt(gornja.Count - 1);
                }
                gornja.Add(tacke[i]);
            }

            donja.RemoveAt(donja.Count - 1);
            gornja.RemoveAt(gornja.Count - 1);
            donja.AddRange(gornja);

            return donja;
        }

        public static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            List<(long x, long y)> tacke = new List<(long, long)>();
            for (int i = 0; i < n; i++)
            {
                string[] koordinate = Console.ReadLine().Split();
                long x = long.Parse(koordinate[0]);
                long y = long.Parse(koordinate[1]);
                tacke.Add((x, y));
            }

            long minimalnaPovrsina = long.MaxValue;
            for (int i = 0; i < n; i++)
            {
                var tackeBezJedne = new List<(long x, long y)>(tacke);
                tackeBezJedne.RemoveAt(i);
                var omotac = KonveksniOmotac(tackeBezJedne);
                long povrsina = Povrsina(omotac);
                if (povrsina < minimalnaPovrsina)
                    minimalnaPovrsina = povrsina;
            }
            Console.WriteLine(minimalnaPovrsina);
        }
    }
}